---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 11
  claims_without_evidence: 3
confidence_derived: 0.79
---

# 根拠レポート：8-pmcstat - ハードウェアパフォーマンスカウンタレポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.79**
  - 根拠あり：11 / 14、根拠なし：3
- 優先レビュー（高）
  1. **トップモードの出力フォーマット詳細**：pmcstat_top.cを未読
  2. **gprof互換プロファイル生成のロジック**：libpmcstatを未読
  3. **カウンティングモードの出力フォーマット**：main関数の全体を読了していない

## 2) 参照した情報（Evidence一覧）

- E-01: `usr.sbin/pmcstat/pmcstat.c` 1-200行目（先頭200行）
- E-02: `usr.sbin/pmcstat/pmcstat.c` 71-106行目（設計コメント）
- E-03: `usr.sbin/pmcstat/pmcstat.c` 108-117行目（グローバル変数）
- E-04: `usr.sbin/pmcstat/pmcstat.c` 119-139行目（pmcstat_get_cpumask関数）
- E-05: `usr.sbin/pmcstat/pmcstat.c` 141-169行目（pmcstat_cleanup関数）
- E-06: `usr.sbin/pmcstat/pmcstat.c` 171-200行目（pmcstat_find_targets関数、先頭部分）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | hwpmc(4)フレームワークを通じてPMCにアクセス | E-01 (54行目: #include <pmc.h>, 55行目: #include <pmclog.h>) | ○ |
| C-02 | カウンティングモードとサンプリングモードの2方式 | E-02 (71-106行目の設計コメント) | ○ |
| C-03 | socketpairで親子プロセス間通信 | E-02 (88-106行目のプロトコル説明) | ○ |
| C-04 | pmcstat_cleanup関数でPMC解放 | E-05 (147-157行目: pmc_stop, pmc_release) | ○ |
| C-05 | ログファイル設定解除(-1) | E-05 (161行目: pmc_configure_logfile(-1)) | ○ |
| C-06 | cpuset_t/CPU_SET/CPU_ZEROでCPU指定 | E-04 (119-139行目) | ○ |
| C-07 | kvm_openfles+kvm_getprocsでプロセス検索 | E-06 (193-199行目) | ○ |
| C-08 | 正規表現でプロセス名マッチ | E-06 (178行目: regex_t) | ○ |
| C-09 | STAILQ_FOREACHでPMCイベントリスト管理 | E-05 (147行目) | ○ |
| C-10 | kqueueベースのイベントループ | E-03 (113行目: pmcstat_kq) | ○ |
| C-11 | libpmcstatにログ解析が集約 | E-01 (67行目: #include <libpmcstat.h>) | ○ |
| C-12 | トップモードの出力フォーマット詳細 | **根拠なし**（pmcstat_top.c未読） | △ |
| C-13 | gprof互換プロファイル生成のロジック | **根拠なし**（libpmcstat未読） | △ |
| C-14 | カウンティングモードの出力フォーマット | **根拠なし**（main関数の全体未読） | △ |

## 4) 不足情報（Unknown / Missing）
- pmcstat_top.cのトップモード表示ロジック
  - 候補：`usr.sbin/pmcstat/pmcstat_top.c`
- libpmcstatのgprof互換プロファイル生成ロジック
  - 候補：`lib/libpmcstat/`
- pmcstat.cのmain関数全体（200行以降の読み込みが限定的）
  - 候補：`usr.sbin/pmcstat/pmcstat.c` の全体

## 5) リスクフラグ（レビュー観点）
- 2: 高リスク - ソースコードの先頭200行のみ読了のため、main関数の処理フロー詳細が未確認。出力フォーマットの正確性に要注意

## 6) レビュアーチェックリスト（最小）
- [ ] pmcstat.cのmain関数全体を読み、処理フローの完全性を確認
- [ ] pmcstat_top.cのトップモード出力フォーマットを確認
- [ ] libpmcstatのgprof互換プロファイル生成ロジックを確認
- [ ] 対応するPMCイベント名のCPUアーキテクチャ依存性を確認
